
<?php $__env->startSection('css'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title">
                <span class="page-title-icon bg-gradient-primary text-white me-2">
                    <i class="mdi mdi-home"></i>
                </span> Withdrawal History
            </h3>
        </div>
        <div class="row">
            <div class="col-lg-12 grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">Withdrawal List</h4>
                        </p>
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Sr.No</th>
                                    <th>User id</th>
                                    <th>Name</th>
                                    <th>Transaction No.</th>
                                    <th>Bank Detail</th>
                                    <th>Amount</th>
                                    <th>Status</th>
                                    <th>Created</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if(count($history) > 0): ?>
                                    <?php $__currentLoopData = $history; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($loop->iteration); ?></td>
                                            <td><?php echo e(appvalidate($history->userid)); ?></td>
                                            <td><?php echo e(appvalidate(userdetail($history->userid, 'name'))); ?></td>
                                            <td><?php echo e(appvalidate($history->transactionno)); ?></td>
                                            <td>
                                                <div>Bank name: <?php echo e(appvalidate($history->bankname)); ?></div><br>
                                                <div>A/C No.: <?php echo e(appvalidate($history->accountno)); ?></div><br>
                                                <div>IFSC Code: <?php echo e(appvalidate($history->ifsccode)); ?></div><br>
                                                <div>Mobile: <?php echo e(appvalidate($history->mobile_no)); ?></div><br>
                                                <div>UPI Id: <?php echo e(appvalidate($history->upi_id)); ?></div>
                                            </td>
                                            <td>₹<?php echo e(appvalidate(number_format($history->amount, 2))); ?></td>
                                            <td><label
                                                    class="badge badge-<?php echo e(status($history->status, 'recharge')['color']); ?>"><?php echo e(status($history->status, 'recharge')['name']); ?></label>
                                            </td>
                                            <td><?php echo e(dformat($history->created_at, 'd-m-Y')); ?></td>
                                            <td>
                                                <?php if($history->status == 0): ?>
                                                    <button class="btn btn-sm btn-success"
                                                        onclick="rechargeapprove('<?php echo e($history->userid); ?>','<?php echo e($history->id); ?>','<?php echo e($history->amount); ?>',this)">approve</button>
                                                    <button class="btn btn-sm btn-danger"
                                                        onclick="rechargecancel('<?php echo e($history->userid); ?>','<?php echo e($history->id); ?>','<?php echo e($history->amount); ?>',this)">Cancel</button>
                                                <?php else: ?>
                                                    <button
                                                        class="btn btn-sm btn-<?php echo e(status($history->status, 'recharge')['color']); ?>"><?php echo e(status($history->status, 'recharge')['name']); ?></button>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="13" class="text-center"> No Withdrawal history found!!</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- content-wrapper ends -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script>
        function rechargeapprove(userid,id,amount,thisc) {
            let form = new FormData();
            form.append('id', id);
            form.append('userid', userid);
            form.append('amount', amount);
            form.append('_token', '<?php echo e(csrf_token()); ?>');
            apex("POST", "<?php echo e(url('admin/api/withdraw/success')); ?>", form, '', "/admin/withdrawal-history", "#");
        }

        function rechargecancel(userid,id,amount,thisc) {
            let form = new FormData();
            form.append('id', id);
            form.append('userid', userid);
            form.append('amount', amount);
            form.append('_token', '<?php echo e(csrf_token()); ?>');
            apex("POST", "<?php echo e(url('admin/api/withdraw/cancel')); ?>", form, '', "/admin/withdrawal-history", "#");
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('Layout.admindashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ziolfvwj00it/public_html/ludokingstar.com/laravel/resources/views/admin/withdrawhistory.blade.php ENDPATH**/ ?>