<?php $__env->startSection('css'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title">
                <span class="page-title-icon bg-gradient-primary text-white me-2">
                    <i class="mdi mdi-timer"></i>
                </span> Plan Crash Time Configuration
            </h3>
            <nav aria-label="breadcrumb">
                <ul class="breadcrumb">
                    <li class="breadcrumb-item active" aria-current="page">
                        <span></span>Configure when plans should automatically crash
                    </li>
                </ul>
            </nav>
        </div>

        <div class="row">
            <?php if(isset($id) && $id != null && $specificdata != null): ?>
                <div class="col grid-margin stretch-card">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="card-title">Edit Crash Time Setting</h4>
                            <div class="alert alert-info">
                                <i class="mdi mdi-information-outline"></i> 
                                Enter a specific crash time (like 1.1 or 13.1) or set to 100 for random crash times.
                            </div>
                            <form class="forms-sample" id="editamountsetup">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="id" value="<?php echo e($id); ?>">
                                <div class="form-group">
                                    <label for="settingname">Setting Name</label>
                                    <input type="text" class="form-control" id="settingname" name="settingname"
                                        placeholder="Setting Name" value="<?php echo e($specificdata->category); ?>" readonly>
                                </div>
                                <div class="form-group">
                                    <label for="value">Crash Time Value</label>
                                    <input type="number" step="0.1" class="form-control" id="value" name="value"
                                        placeholder="Enter crash time" value="<?php echo e($specificdata->value); ?>" required>
                                    <small class="text-muted">Enter value in format like 1.1, 2.5, etc. or 100 for random</small>
                                </div>
                                <button type="submit" class="btn btn-gradient-primary me-2">Update Setting</button>
                                <button type="button" class="btn btn-light" onclick="window.location.href='/admin/plan-crash-time'">Cancel</button>
                            </form>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        <div class="row">
            <div class="col grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">Current Crash Time Settings</h4>
                        <div class="alert alert-warning">
                            <i class="mdi mdi-alert-circle-outline"></i>
                            <strong>Important Rules:</strong> See below how different values affect crash times
                        </div>
                        
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead class="thead-light">
                                    <tr>
                                        <th>#</th>
                                        <th>Setting Name</th>
                                        <th>Current Value</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $setting; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e($item->category); ?></td>
                                        <td>
                                            <span class="badge badge-<?php echo e($item->value == 100 ? 'success' : 'info'); ?>">
                                                <?php echo e($item->value); ?>

                                            </span>
                                        </td>
                                        <td>
                                            <button class="btn btn-sm btn-outline-primary" 
                                                    onclick="window.location.href='plan-crash-time/<?php echo e($item->id); ?>'">
                                                <i class="mdi mdi-pencil"></i> Edit
                                            </button>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        
                        <div class="mt-4">
                            <div class="card bg-light">
                                <div class="card-body">
                                    <h5 class="card-title"><i class="mdi mdi-help-circle-outline text-primary"></i> Crash Time Rules</h5>
                                    <ul class="list-arrow">
                                        <li><strong>Fixed Time Rules:</strong>
                                            <ul>
                                                <li>Value 10 means crash between 1.0x to 1.9x</li>
                                                <li>Value 20 means crash between 2.0x to 2.9x</li>
                                                <li>Value 30 means crash between 3.0x to 3.9x</li>
                                                <li>Value 40 means crash between 4.0x to 4.9x</li>
                                            </ul>
                                        </li>
                                        <li><strong>Specific Value Rule:</strong> 
                                            Enter exact value like 1.1 or 10.1 to crash at exactly that multiplier
                                        </li>
                                        <li><strong>Random Mode Rule:</strong> 
                                            Set value to 100 to enable random crash times (system will auto-generate)
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script>
        $("#editamountsetup").on('submit', function(e) {
            e.preventDefault();
        });
        
        $("#editamountsetup").validate({
            rules: {
                value: {
                    required: true,
                    number: true,
                    min: 1
                }
            },
            messages: {
                value: {
                    required: "Please enter a crash time value",
                    number: "Value must be a number",
                    min: "Value must be at least 1"
                }
            },
            submitHandler: function(form) {
                apex("POST", "<?php echo e(url('admin/api/editamountsetup')); ?>", new FormData(form), form,
                    "/admin/plan-crash-time", "#");
            }
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('Layout.admindashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aviator2hn/public_html/laravel/resources/views/admin/crasedtime.blade.php ENDPATH**/ ?>