@extends('Layout.admindashboard')
@section('css')
@endsection

@section('content')
    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title">
                <span class="page-title-icon bg-gradient-primary text-white me-2">
                    <i class="mdi mdi-timer"></i>
                </span> Plan Crash Time Configuration
            </h3>
            <nav aria-label="breadcrumb">
                <ul class="breadcrumb">
                    <li class="breadcrumb-item active" aria-current="page">
                        <span></span>Configure when plans should automatically crash
                    </li>
                </ul>
            </nav>
        </div>

        <div class="row">
            @if (isset($id) && $id != null && $specificdata != null)
                <div class="col grid-margin stretch-card">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="card-title">Edit Crash Time Setting</h4>
                            <div class="alert alert-info">
                                <i class="mdi mdi-information-outline"></i> 
                                Enter a specific crash time (like 1.1 or 13.1) or set to 100 for random crash times.
                            </div>
                            <form class="forms-sample" id="editamountsetup">
                                @csrf
                                <input type="hidden" name="id" value="{{ $id }}">
                                <div class="form-group">
                                    <label for="settingname">Setting Name</label>
                                    <input type="text" class="form-control" id="settingname" name="settingname"
                                        placeholder="Setting Name" value="{{$specificdata->category}}" readonly>
                                </div>
                                <div class="form-group">
                                    <label for="value">Crash Time Value</label>
                                    <input type="number" step="0.1" class="form-control" id="value" name="value"
                                        placeholder="Enter crash time" value="{{$specificdata->value}}" required>
                                    <small class="text-muted">Enter value in format like 1.1, 2.5, etc. or 100 for random</small>
                                </div>
                                <button type="submit" class="btn btn-gradient-primary me-2">Update Setting</button>
                                <button type="button" class="btn btn-light" onclick="window.location.href='/admin/plan-crash-time'">Cancel</button>
                            </form>
                        </div>
                    </div>
                </div>
            @endif
        </div>

        <div class="row">
            <div class="col grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">Current Crash Time Settings</h4>
                        <div class="alert alert-warning">
                            <i class="mdi mdi-alert-circle-outline"></i>
                            <strong>Important Rules:</strong> See below how different values affect crash times
                        </div>
                        
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead class="thead-light">
                                    <tr>
                                        <th>#</th>
                                        <th>Setting Name</th>
                                        <th>Current Value</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($setting as $item)
                                    <tr>
                                        <td>{{$loop->iteration}}</td>
                                        <td>{{$item->category}}</td>
                                        <td>
                                            <span class="badge badge-{{ $item->value == 100 ? 'success' : 'info' }}">
                                                {{$item->value}}
                                            </span>
                                        </td>
                                        <td>
                                            <button class="btn btn-sm btn-outline-primary" 
                                                    onclick="window.location.href='plan-crash-time/{{$item->id}}'">
                                                <i class="mdi mdi-pencil"></i> Edit
                                            </button>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        
                        <div class="mt-4">
                            <div class="card bg-light">
                                <div class="card-body">
                                    <h5 class="card-title"><i class="mdi mdi-help-circle-outline text-primary"></i> Crash Time Rules</h5>
                                    <ul class="list-arrow">
                                        <li><strong>Fixed Time Rules:</strong>
                                            <ul>
                                                <li>Value 10 means crash between 1.0x to 1.9x</li>
                                                <li>Value 20 means crash between 2.0x to 2.9x</li>
                                                <li>Value 30 means crash between 3.0x to 3.9x</li>
                                                <li>Value 40 means crash between 4.0x to 4.9x</li>
                                            </ul>
                                        </li>
                                        <li><strong>Specific Value Rule:</strong> 
                                            Enter exact value like 1.1 or 10.1 to crash at exactly that multiplier
                                        </li>
                                        <li><strong>Random Mode Rule:</strong> 
                                            Set value to 100 to enable random crash times (system will auto-generate)
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    <script>
        $("#editamountsetup").on('submit', function(e) {
            e.preventDefault();
        });
        
        $("#editamountsetup").validate({
            rules: {
                value: {
                    required: true,
                    number: true,
                    min: 1
                }
            },
            messages: {
                value: {
                    required: "Please enter a crash time value",
                    number: "Value must be a number",
                    min: "Value must be at least 1"
                }
            },
            submitHandler: function(form) {
                apex("POST", "{{ url('admin/api/editamountsetup') }}", new FormData(form), form,
                    "/admin/plan-crash-time", "#");
            }
        });
    </script>
@endsection